from tool.darknet2pytorch import Darknet
import torch
import datetime

cfgFile = "./origin/obj.cfg"
ffeModel= "./origin/obj_last.weights" # Weights
save_fn = "./dest/"+ datetime.datetime.now().strftime("%Y-%m-%d_%H-%M-%S") + ".pt" 

ffe = Darknet(cfgFile, inference=True)
ffe.load_weights(ffeModel)
ckpt = {
    'model': ffe,          # This saves the whole model object
    'nc': ffe.num_classes, # Number of classes
}
torch.save(ckpt, save_fn)